/******************************************************
Monte Carlo Experiments to Assess the Coverage of
Marginal vs. Scheffe Bands for path forecasts.

"Path Forecasting Evaluation" by Oscar Jorda and
Massimiliano Marcellino (2008)

Revision for Journal of Applied Econometrics

Per referee requests
- The DGP is a AR for different values of Rho.

Author: Oscar Jorda
Initial Date: 6/26/2008
Last Updated: 6/27/2008
*******************************************************/
new;
cls;

// output your simulations to a file here
//output file = ar_h12_a05_h.out reset;
/*******************************************
Initial Analysis Choices
********************************************/
hmax = 12;           // Forecast horizon 
alpha = 0.05;        // Size of tests

vars = 1;		     // variables in the data set 
freps = 1000;         // Forecast replilcations
p = 1;               // lag length of AR(1)
state   =   10;      //meaningless used for rng
sig =   1;          // residual variance
/******************************************************
Do for several values of rho
******************************************************/
rho = seqa(0.5,0.1,5);  //AR parameters
rho = 0.75;
l = 1;
do while l le rows(rho);

/******************************************
Generate freps paths conditional on the last
observations from the actual data
******************************************/
yf = zeros(hmax*vars, freps);
//we will later stack the paths for the variables using vec()

i = 1;          //Counter
// Construct the regressors
//************************************************************
y = zeros(hmax,vars);
do while i le freps;
        xf = 0;
        {uf, state} = rndKMn(hmax,vars,state);
        y[1,.] =  xf*rho[l] + (sig^0.5)*uf[1,.];
        h = 2;
        do while h le hmax;
            xf = y[h-1,.];
            y[h,.] =  xf*rho[l] + (sig^0.5)*uf[h,.];
            h = h+1;
        endo;
        yf[.,i] = y;
        i = i+1;
endo;
/*************************************************************
Construct the Forecast Error Variance
*************************************************************/
Phi = 1;
rw = rho[l]~1;
h = 2;
do while h le hmax;
    Phi = (Phi~zeros(h-1,1))|rw;
    rw = (rho[l]^h)~rw;
    h = h+1;
endo;
Xi_H = Phi*(eye(hmax).*.sig)*Phi';


//Coverage of the different methods
{ar_m,ar_b,ar_s,ar_c,ar_wm,ar_wb,ar_ws,ar_wc} = evalc(yf, vars, hmax, xi_H);



"===========================================================";
"       SIMULATION SET_UP                                   ";
"===========================================================";
"Forecast Horizon:      ";; hmax;
"Forecast Replications: ";; freps;
"MC Replications:       ";; freps;
"Value of Rho           ";; rho[l];
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF VAR BASED BANDS";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(ar_m')~meanc(ar_b')~meanc(ar_s')@~meanc(ar_c')@;
"-----------------------------------------------------------";
"PROBABILITY COVERAGE OF VAR BASED BANDS - WALD DISTANCE";
"-----------------------------------------------------------";
"Nominal Level"$~"Marginal"$~"Bonferroni"$~"Scheffe"@$~"Conditional"@;
(1-alpha)*ones(vars,1)~meanc(ar_wm')~meanc(ar_wb')~meanc(ar_ws')@~meanc(ar_wc')@;



l = l+1;
endo;

/*******************************************************
Libraries
********************************************************/
#include jae_mc.src;
library pgraph;
graphset;
